/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals;

import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.environment.GameClock;

public class IdleGoal
extends Goal {
    private final float timeToIdleTimeInGameHours;
    private float elapsedTimeInGameHours;

    public IdleGoal(Entity parentEntity, float timeToIdleTimeInGameHours) {
        super(parentEntity);
        this.timeToIdleTimeInGameHours = timeToIdleTimeInGameHours;
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        this.elapsedTimeInGameHours = (float)((double)this.elapsedTimeInGameHours + GameClock.realTimeToGameHours(deltaTimeSeconds));
    }

    @Override
    public boolean isComplete() {
        return this.elapsedTimeInGameHours > this.timeToIdleTimeInGameHours;
    }
}

